import { createSlice, createAsyncThunk } from '@reduxjs/toolkit';

import { BASE_API_URL_STG } from '@env';
import { queryResponse } from '../util/processResponse.js';

const initialState = {
    allPreferences: null,
    loading: false,
};

export const getPreferences = createAsyncThunk('getPreferences', async () => {
    const URL = `${BASE_API_URL_STG}/preferences`;
    const response = await queryResponse(URL);
    return response;
});

const getAllPreferences = createSlice({
    name: 'getPreferences',
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getPreferences.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getPreferences.fulfilled, (state, { payload }) => {
            const { status, records } = payload || {};
            if (status?.code === 200) {
                state.allPreferences = records?.data;
            }
            state.loading = false;
        });
        builder.addCase(getPreferences.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default getAllPreferences.reducer;
